<?php
#	SonicCampGuard
#
#	Copyright (c) 2024 Bundeswehr
#	Diese Anwendung wurde von Cedric Prietz entwickelt.
#	E-Mail: CedricPrietz@bundeswehr.org
#	App: 90-8303-54618
#
#	Letzte Änderung: 21.01.2025

require_once $_SERVER['DOCUMENT_ROOT'] . '/function.inc.php';
pageName('Sperrlisteneintrag Bearbeiten');
requireLogin();
requireRole(['Bearbeiter', 'Administrator']);
showSessionAlert();
initializeDatabaseConnection();

$sql = "SELECT * FROM BlacklistLocals WHERE ID = ?";
$stmt = $pdo->prepare($sql);
$stmt->execute([$_GET['id']]);

$blacklistEntry = $stmt->fetch();

if (!$blacklistEntry) {

    header("Location: /identities/blacklist");
    exit();

}

if (isset($_POST['updateBlacklistEntry'])) {

    // Daten Updaten
    updateDBEntry('BlacklistLocals', 'ID', $_GET['id'], 'Surname', $_POST['identitySurname']);
    updateDBEntry('BlacklistLocals', 'ID', $_GET['id'], 'Givenname', $_POST['identityGivenname']);
    updateDBEntry('BlacklistLocals', 'ID', $_GET['id'], 'Birthday', $_POST['identityBirthday']);
    updateDBEntry('BlacklistLocals', 'ID', $_GET['id'], 'Nationality', $_POST['identityNationality']);
    updateDBEntry('BlacklistLocals', 'ID', $_GET['id'], 'Company', $_POST['identityCompany']);
    updateDBEntry('BlacklistLocals', 'ID', $_GET['id'], 'Reason', $_POST['blacklistReason']);
    updateDBEntry('BlacklistLocals', 'ID', $_GET['id'], 'Notes', $_POST['blacklistNotes']);

    if ($_POST['identityIDCard']) {
        updateDBEntry('BlacklistLocals', 'ID', $_GET['id'], 'IDCard', $_POST['identityIDCard']);
    }

    // AuditLog: Eintrag erstellen
    addAuditLog($_SESSION['Username'], 'Sperrliste', 'Eintrag "' . $blacklistEntry['Surname'] . ', ' . $blacklistEntry['Givenname'] . '" bearbeitet');

    // Alert: Speichern Erfolgreich
    createSessionAlert("", "Eintrag <h5 class='pt-2 pb-2'>" . $blacklistEntry['Surname'] . ", " . $blacklistEntry['Givenname'] . "</h5> wurde erfolgreich aktualisiert", "success", "false", "2000");

    // Weiterleitung zur Übersicht
    header("Location: /identities/blacklist");
    exit();

}

if (isset($_POST['deleteBlacklistEntry'])) {

    // AuditLog: Eintrag erstellen
    addAuditLog($_SESSION['Username'], 'Sperrliste', 'Eintrag "' . $blacklistEntry['Surname'] . ', ' . $blacklistEntry['Givenname'] . '" aus der Sperrliste entfernt');

    // Alert: Löschen Erfolgreich
    createSessionAlert("", "Eintrag <h4 class='pt-2 pb-2'>" . $blacklistEntry['Surname'] . ", " . $blacklistEntry['Givenname'] . "</h4> wurde erfolgreich gelöscht", "success", "false", "3000");

    // Löschen der Daten in der Datenbank
    deleteDBEntry('BlacklistLocals', 'ID', $_GET['id']);

    // Weiterleitung zur Übersicht
    header("Location: /identities/blacklist");
    exit();
}

include($_SERVER['DOCUMENT_ROOT'] . '/header.inc.php');
?>

<form action="" method="post" id="updateBlacklistEntry" enctype="multipart/form-data">

    <div class="d-flex justify-content-between align-items-center flex-wrap grid-margin">
        <div>
            <h4 class="mb-md-0"><?php echo $blacklistEntry['Surname'] . ", " . $blacklistEntry['Givenname']; ?></h4>
            <span class="text-secondary">Bearbeiten</span>
        </div>
        <div class="d-flex align-items-center flex-wrap text-nowrap">

            <button class="btn btn-primary btn-icon-text me-2" type="submit" name="updateBlacklistEntry">
                <i class="btn-icon-prepend mdi mdi-check-bold"></i>
                Speichern
            </button>

            <button type="button" class="btn btn-danger btn-icon-text mb-2 mb-md-0 me-2" data-bs-toggle="modal"
                data-bs-target="#modalDeleteBlacklistEntry">
                <i class="btn-icon-prepend mdi mdi-delete"></i>
                Löschen
            </button>

            <a href="/identities/blacklist" class="btn btn-secondary btn-icon mb-2 mb-md-0">
                <i class="mdi mdi-arrow-left-top"></i>
            </a>

        </div>
    </div>

    <div class="row">

        <div class="col-lg-12 col-xl-4 grid-margin">
            <div class="card">
                <div class="card-header bg-primary text-white">
                    Stammdaten
                </div>
                <div class="card-body">
                    <div class="mb-3">
                        <label for="identitySurname" class="form-label">Nachname</label>
                        <input id="identitySurname" name="identitySurname" class="form-control" type="text"
                            value="<?php echo $blacklistEntry['Surname']; ?>">
                    </div>
                    <div class=" mb-3">
                        <label for="identityGivenname" class="form-label">Vorname</label>
                        <input id="identityGivenname" name="identityGivenname" class="form-control"
                            value="<?php echo $blacklistEntry['Givenname']; ?>" type="text">
                    </div>
                    <div class="mb-3">
                        <label for="identityBirthday" class="form-label">Geburtstag</label>
                        <div class="input-group flatpickr" id="flatpickr-date">
                            <input type="date" class="form-control" id="identityBirthday" name="identityBirthday"
                                value="<?php echo $blacklistEntry['Birthday']; ?>" data-input>
                            <span class="input-group-text input-group-addon" data-toggle><i
                                    data-feather="calendar"></i></span>
                        </div>
                    </div>
                    <div class="mb-3">
                        <label class="form-label">Nationalität</label>
                        <select class="js-example-basic-single form-select form-control" name="identityNationality"
                            data-width="100%">
                            <option value="N/A" selected>Keine Auswahl</option>
                            <?php

                            // Datenbankabfrage
                            $sql = "SELECT * FROM SystemNationalities";
                            $stmt = $pdo->query($sql);
                            $Nationalities = $stmt->fetchAll();

                            if ($Nationalities) {
                                foreach ($Nationalities as $Nationality) {
                                    echo '<option value="' . $Nationality['Nationality'] . '"';
                                    if ($Nationality['Nationality'] == $blacklistEntry['Nationality']) {
                                        echo ' selected';
                                    }
                                    echo '>' . $Nationality['Nationality'] . '</option>';
                                }
                            }

                            ?>
                        </select>
                    </div>
                    <div class="mb-3">
                        <label for="identityIDCard" class="form-label">Ausweisnummer</label>
                        <input id="identityIDCard" name="identityIDCard" class="form-control"
                            placeholder="<?php echo $blacklistEntry['IDCard']; ?>" type="text">
                    </div>
                    <div class="mb-3">
                        <label for="identityCompany" class="form-label">Firma</label>
                        <input id="identityCompany" name="identityCompany" class="form-control"
                            value="<?php echo $blacklistEntry['Company']; ?>" type="text">
                    </div>
                </div>
            </div>
        </div>

        <div class="col-lg-12 col-xl-8 grid-margin">

            <div class="card grid-margin">
                <div class="card-header bg-warning text-white">
                    Begründung
                </div>
                <div class="card-body">
                    <textarea class="form-control" name="blacklistReason" id="blacklistReasonMDE"
                        rows="8"><?php echo $blacklistEntry['Reason']; ?></textarea>
                </div>
            </div>

            <div class="card">
                <div class="card-header">
                    Notizen
                </div>
                <div class="card-body">
                    <textarea class="form-control" name="blacklistNotes" id="blacklistNotesMDE" rows="5"
                        autofocus><?php echo $blacklistEntry['Notes']; ?></textarea>
                </div>
            </div>

        </div>

    </div>

</form>

<!-- Modal : Identität Löschen -->
<div class="modal fade" id="modalDeleteBlacklistEntry" tabindex="-1" aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered">
        <div class="modal-content">
            <form action="" method="POST">
                <div class="modal-header">
                    <h5 class="modal-title">Löschen</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="btn-close"></button>
                </div>
                <div class="modal-body">
                    <p class="fw-bold mb-2">Den Eintrag von
                        "<?php echo $blacklistEntry['Surname'] . ", " . $blacklistEntry['Givenname'] ?>" wirklich
                        löschen?</p>
                    <p class="mb-2">Durch das Löschen des Eintrages kann die Person wieder in den Identitäten angelegt
                        werden.</p>
                    <p>Der Vorgang kann nicht rückgängig gemacht werden.</p>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Abbrechen</button>
                    <button type="submit" class="btn btn-icon-text btn-danger" name="deleteBlacklistEntry">
                        <i class="btn-icon-prepend mdi mdi-delete"></i>
                        Löschen
                    </button>
                </div>
            </form>
        </div>
    </div>
</div>

<?php include($_SERVER['DOCUMENT_ROOT'] . '/footer.inc.php'); ?>